//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI;

namespace SID_monitor
{
    public partial class ChannelsDockablePanel : DockContent
    {
        private CheckBox[] checkBoxChannels = new CheckBox[16]; // checkBox of the graph selection
        private Label[] labelChannelValues = new Label[16]; // Label of channel Values


        public ChannelsDockablePanel()
        {
            InitializeComponent();

            // setting channel selection on graph and value labels
            for (int i = 0; i < checkBoxChannels.Length; i++)
            {
                checkBoxChannels[i] = new CheckBox();
                checkBoxChannels[i].AutoSize = true;
                checkBoxChannels[i].Location = new System.Drawing.Point(6, 83 + 23 * i);
                checkBoxChannels[i].Size = new System.Drawing.Size(46, 17);
                checkBoxChannels[i].Name = "checkBoxChannel" + (i + 1).ToString();
                checkBoxChannels[i].Text = SID_monitor.Properties.Settings.ChannelTitles[i];
                checkBoxChannels[i].Click += new System.EventHandler(this.checkBoxChannel_CheckedChanged);


                labelChannelValues[i] = new Label();
                labelChannelValues[i].AutoSize = false;
                labelChannelValues[i].Location = new System.Drawing.Point(140, 83 + 23 * i);
                labelChannelValues[i].Size = new System.Drawing.Size(58, 17);
                labelChannelValues[i].BorderStyle = BorderStyle.Fixed3D;
                labelChannelValues[i].ImageAlign = ContentAlignment.MiddleRight;
                labelChannelValues[i].TextAlign = ContentAlignment.MiddleLeft;
                labelChannelValues[i].Name = "labelChannelValue" + (i + 1).ToString();
            }

            setGraphChannelsItems();
        }

        #region Initialisation Methods

        public void setGraphChannelsItems()
        {
            #region Checkboxes for channel selection on graph and value labels

            // Channels 1
            checkBoxChannels[0].Enabled = SID_monitor.Properties.Settings.Default.Channel1Active;
            checkBoxChannels[0].Checked = SID_monitor.Properties.Settings.Default.Channel1Active;
            labelChannelValues[0].Enabled = SID_monitor.Properties.Settings.Default.Channel1Active;
            labelChannelValues[0].Text = "";
            labelChannelValues[0].Image = null;

            // Channels 2
            checkBoxChannels[1].Enabled = SID_monitor.Properties.Settings.Default.Channel2Active;
            checkBoxChannels[1].Checked = SID_monitor.Properties.Settings.Default.Channel2Active;
            labelChannelValues[1].Enabled = SID_monitor.Properties.Settings.Default.Channel2Active;
            labelChannelValues[1].Text = "";
            labelChannelValues[1].Image = null;

            // Channels 3
            checkBoxChannels[2].Enabled = SID_monitor.Properties.Settings.Default.Channel3Active;
            checkBoxChannels[2].Checked = SID_monitor.Properties.Settings.Default.Channel3Active;
            labelChannelValues[2].Enabled = SID_monitor.Properties.Settings.Default.Channel3Active;
            labelChannelValues[2].Text = "";
            labelChannelValues[2].Image = null;

            // Channels 4
            checkBoxChannels[3].Enabled = SID_monitor.Properties.Settings.Default.Channel4Active;
            checkBoxChannels[3].Checked = SID_monitor.Properties.Settings.Default.Channel4Active;
            labelChannelValues[3].Enabled = SID_monitor.Properties.Settings.Default.Channel4Active;
            labelChannelValues[3].Text = "";
            labelChannelValues[3].Image = null;

            // Channels 5
            checkBoxChannels[4].Enabled = SID_monitor.Properties.Settings.Default.Channel5Active;
            checkBoxChannels[4].Checked = SID_monitor.Properties.Settings.Default.Channel5Active;
            labelChannelValues[4].Enabled = SID_monitor.Properties.Settings.Default.Channel5Active;
            labelChannelValues[4].Text = "";
            labelChannelValues[4].Image = null;

            // Channels 6
            checkBoxChannels[5].Enabled = SID_monitor.Properties.Settings.Default.Channel6Active;
            checkBoxChannels[5].Checked = SID_monitor.Properties.Settings.Default.Channel6Active;
            labelChannelValues[5].Enabled = SID_monitor.Properties.Settings.Default.Channel6Active;
            labelChannelValues[5].Text = "";
            labelChannelValues[5].Image = null;

            // Channels 7
            checkBoxChannels[6].Enabled = SID_monitor.Properties.Settings.Default.Channel7Active;
            checkBoxChannels[6].Checked = SID_monitor.Properties.Settings.Default.Channel7Active;
            labelChannelValues[6].Enabled = SID_monitor.Properties.Settings.Default.Channel7Active;
            labelChannelValues[6].Text = "";
            labelChannelValues[6].Image = null;

            // Channels 8
            checkBoxChannels[7].Enabled = SID_monitor.Properties.Settings.Default.Channel8Active;
            checkBoxChannels[7].Checked = SID_monitor.Properties.Settings.Default.Channel8Active;
            labelChannelValues[7].Enabled = SID_monitor.Properties.Settings.Default.Channel8Active;
            labelChannelValues[7].Text = "";
            labelChannelValues[7].Image = null;

            // Channels 9
            checkBoxChannels[8].Enabled = SID_monitor.Properties.Settings.Default.Channel9Active;
            checkBoxChannels[8].Checked = SID_monitor.Properties.Settings.Default.Channel9Active;
            labelChannelValues[8].Enabled = SID_monitor.Properties.Settings.Default.Channel9Active;
            labelChannelValues[8].Text = "";
            labelChannelValues[8].Image = null;

            // Channels 10
            checkBoxChannels[9].Enabled = SID_monitor.Properties.Settings.Default.Channel10Active;
            checkBoxChannels[9].Checked = SID_monitor.Properties.Settings.Default.Channel10Active;
            labelChannelValues[9].Enabled = SID_monitor.Properties.Settings.Default.Channel10Active;
            labelChannelValues[9].Text = "";
            labelChannelValues[9].Image = null;

            // Channels 11
            checkBoxChannels[10].Enabled = SID_monitor.Properties.Settings.Default.Channel11Active;
            checkBoxChannels[10].Checked = SID_monitor.Properties.Settings.Default.Channel11Active;
            labelChannelValues[10].Enabled = SID_monitor.Properties.Settings.Default.Channel11Active;
            labelChannelValues[10].Text = "";
            labelChannelValues[10].Image = null;

            // Channels 12
            checkBoxChannels[11].Enabled = SID_monitor.Properties.Settings.Default.Channel12Active;
            checkBoxChannels[11].Checked = SID_monitor.Properties.Settings.Default.Channel12Active;
            labelChannelValues[11].Enabled = SID_monitor.Properties.Settings.Default.Channel12Active;
            labelChannelValues[11].Text = "";
            labelChannelValues[11].Image = null;

            // Channels 13
            checkBoxChannels[12].Enabled = SID_monitor.Properties.Settings.Default.Channel13Active;
            checkBoxChannels[12].Checked = SID_monitor.Properties.Settings.Default.Channel13Active;
            labelChannelValues[12].Enabled = SID_monitor.Properties.Settings.Default.Channel13Active;
            labelChannelValues[12].Text = "";
            labelChannelValues[12].Image = null;

            // Channels 14
            checkBoxChannels[13].Enabled = SID_monitor.Properties.Settings.Default.Channel14Active;
            checkBoxChannels[13].Checked = SID_monitor.Properties.Settings.Default.Channel14Active;
            labelChannelValues[13].Enabled = SID_monitor.Properties.Settings.Default.Channel14Active;
            labelChannelValues[13].Text = "";
            labelChannelValues[13].Image = null;

            // Channels 15
            checkBoxChannels[14].Enabled = SID_monitor.Properties.Settings.Default.Channel15Active;
            checkBoxChannels[14].Checked = SID_monitor.Properties.Settings.Default.Channel15Active;
            labelChannelValues[14].Enabled = SID_monitor.Properties.Settings.Default.Channel15Active;
            labelChannelValues[14].Text = "";
            labelChannelValues[14].Image = null;

            // Channels 16
            checkBoxChannels[15].Enabled = SID_monitor.Properties.Settings.Default.Channel16Active;
            checkBoxChannels[15].Checked = SID_monitor.Properties.Settings.Default.Channel16Active;
            labelChannelValues[15].Enabled = SID_monitor.Properties.Settings.Default.Channel16Active;
            labelChannelValues[15].Text = "";
            labelChannelValues[15].Image = null;

            for (int i = 0; i < 16; i++)
            {
                this.Controls.Add(checkBoxChannels[i]);
                this.Controls.Add(labelChannelValues[i]);
            }
            #endregion
        }
        #endregion

        #region Properties
        public CheckBox[] CheckBoxChannels
        {
            get
            {
                return this.checkBoxChannels;
            }
        }

        public Label[] LabelChannelValues
        {
            get
            {
                return this.labelChannelValues;
            }
        }

        public bool ShowSunChecked
        {
            get
            {
                return this.checkBoxShowSun.Checked;

            }
            set
            {
                this.checkBoxShowSun.Checked = value;
            }
        }

        public bool ShowForecastChecked
        {
            get
            {
                return this.checkBoxShowForecast.Checked;

            }
            set
            {
                this.checkBoxShowForecast.Checked = value;
            }
        }

        #endregion

        #region Checkboxes Handling
        private void checkBoxShowSun_CheckedChanged(object sender, EventArgs e)
        {
            OnShowSunChanged(new ShowChangeEventArgs(checkBoxShowSun.Checked));
        }

        private void checkBoxShowForecast_CheckedChanged(object sender, EventArgs e)
        {
            OnShowForecastChanged(new ShowChangeEventArgs(checkBoxShowForecast.Checked));
        }

        private void checkBoxChannel_CheckedChanged(object sender, EventArgs e)
        {
            int id = -1;

            for (int i = 0; i < checkBoxChannels.Length; i++)
            {
                if (checkBoxChannels[i].Equals((CheckBox)sender))
                {
                    id = i;
                    OnShowChannelsChanged(new ChannelsShowChangeEventArgs(id, checkBoxChannels[id].Checked));
                    break;
                }
            }
            if (id == -1)
            {
                OnShowChannelsChanged(new ChannelsShowChangeEventArgs(id, false));
            }
        }

        #endregion

        #region Events

        /// <summary>
        /// ShowSunChanged and ShowForecastChanged Events
        /// </summary>

        public class ShowChangeEventArgs : EventArgs
        {
            private bool show = false;

            public ShowChangeEventArgs(bool show)
            {
                this.show = show;
            }

            public bool Show
            {
                get
                {
                    return Show;
                }
            }
        }

        public delegate void ShowChangeEventHandler(object sender, ShowChangeEventArgs e);

        public event ShowChangeEventHandler ShowSunChanged; // the GOES-10 show checkbox has changed
        public event ShowChangeEventHandler ShowForecastChanged; // the GOES-12 show checkbox has changed

        protected virtual void OnShowSunChanged(ShowChangeEventArgs e)
        {
            ShowChangeEventHandler handler = ShowSunChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        protected virtual void OnShowForecastChanged(ShowChangeEventArgs e)
        {
            ShowChangeEventHandler handler = ShowForecastChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }


        /// <summary>
        /// ShowChannelsChanged Event
        /// </summary>

        public class ChannelsShowChangeEventArgs : EventArgs
        {
            private bool show = false;
            private int channel_id = -1;

            public ChannelsShowChangeEventArgs(int id, bool show)
            {
                this.channel_id = id;
                this.show = show;
            }

            public bool Show
            {
                get
                {
                    return Show;
                }
            }

            public int Id
            {
                get
                {
                    return channel_id;
                }
            }
        }

        public delegate void ChannelsShowChangeEventHandler(object sender, ChannelsShowChangeEventArgs e);

        public event ChannelsShowChangeEventHandler ShowChannelsChanged; // the GOES-10 show checkbox has changed

        protected virtual void OnShowChannelsChanged(ChannelsShowChangeEventArgs e)
        {
            ChannelsShowChangeEventHandler handler = ShowChannelsChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        #endregion
    }
}
